/* EEPROM Functions. 
   Reference STC Series Datasheet */
#include "eeprom.h"
#include "stc32g.h"

//========================================================================
// : void DisableEEPROM(void)
// : ֹEEPROM.
// : none.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void DisableEEPROM(void)        //ֹEEPROM
{
    IAP_CONTR = 0;          //ر IAP 
    IAP_CMD = 0;            //Ĵ
    IAP_TRIG = 0;           //Ĵ
    IAP_ADDRE = 0xff;       //ַõ IAP 
    IAP_ADDRH = 0xff;       //ַõ IAP 
    IAP_ADDRL = 0xff;
}

//========================================================================
// : void EEPROM_Trig(void)
// : EEPROM.
// : none.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_Trig(void)
{
    F0 = EA;    //ȫж
    EA = 0;     //ֹж, ⴥЧ
    IAP_TRIG = 0x5A;
    IAP_TRIG = 0xA5;                    //5AHA5HIAPĴÿζҪ
                                        //A5HIAP
                                        //CPUȴIAPɺ󣬲Żִг
    _nop_();   //STC32GǶ༶ˮߵָϵͳ4NOP֤IAP_DATA׼
    _nop_();
    _nop_();
    _nop_();
    EA = F0;    //ָȫж
}

//========================================================================
// : void EEPROM_SectorErase(uint32 EE_address)
// : һ.
// : EE_address:  ҪEEPROMеһֽڵַ.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_SectorErase(uint32 EE_address)
{
    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    IAP_ERASE();                        //, ıʱ
                                        //ֻûֽڲ512ֽ/
                                        //һֽڵַַ
    IAP_ADDRE = (uint8)(EE_address >> 16); //ַֽڣַҪıʱ͵ַ
    IAP_ADDRH = (uint8)(EE_address >> 8);  //ַֽڣַҪıʱ͵ַ
    IAP_ADDRL = (uint8)EE_address;         //ַֽڣַҪıʱ͵ַ
    EEPROM_Trig();                      //EEPROM
    DisableEEPROM();                    //ֹEEPROM
}

//========================================================================
// : void EEPROM_read_n(uint32 EE_address,uint8 *DataAddress,uint8 lenth)
// : Nֽں.
// : EE_address:  ҪEEPROM׵ַ.
//       DataAddress: Ҫݵָ.
//       length:      Ҫĳ
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_read_n(uint32 EE_address,uint8 *DataAddress,uint8 length)
{
    if(length == 0) return;   //Ϊ0

    IAP_ENABLE();                           //õȴʱ䣬IAPһξ͹
    IAP_READ();                             //ֽڶıʱ
    do
    {
        IAP_ADDRE = (uint8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (uint8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (uint8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        *DataAddress = IAP_DATA;            //
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
}


//========================================================================
// : uint8 EEPROM_write_n(uint32 EE_address,uint8 *DataAddress,uint8 length)
// : дNֽں.
// : EE_address:  ҪдEEPROM׵ַ.
//       DataAddress: Ҫдݵָ.
//       length:      Ҫдĳ
// : 1: дȷ.  0: д.
// 汾: V1.0, 2014-6-30
//========================================================================
uint8 EEPROM_write_n(uint32 EE_address,uint8 *DataAddress,uint8 length)
{
    uint8  i;
    uint16 j;
    uint8  *p;
    
    if(length == 0) return 0;   //Ϊ0

    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    i = length;
    j = EE_address;
    p = DataAddress;
    IAP_WRITE();                            //, ֽд
    do
    {
        IAP_ADDRE = (uint8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (uint8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (uint8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_DATA  = *DataAddress;           //ݵIAP_DATAֻݸıʱ
        EEPROM_Trig();                      //EEPROM
        EE_address++;                       //һַ
        DataAddress++;                      //һ
    }while(--length);                       //ֱ

    EE_address = j;
    length = i;
    DataAddress = p;
    i = 1;
    IAP_READ();                             //NֽڲȽ
    do
    {
        IAP_ADDRE = (uint8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (uint8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (uint8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        if(*DataAddress != IAP_DATA)        //ԴݱȽ
        {
            i = 0;
            break;
        }
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
    return i;
}


/* Write EEPROM
   s: Pointer to parameters
   para_num: Length of parameters */
bit EEPROM_Save(uint8 *s, uint8 para_num)
{
	//
    EEPROM_SectorErase(IAP_ADDRESS); 
	//EEPROM
    return(EEPROM_write_n(IAP_ADDRESS,s,para_num));
}
